/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.rping;

import ibm.nways.jdm.RemoteModelImpl;
import ibm.nways.jdm.modelgen.HandcodedModel;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.jdm.snmp.SnmpPDU;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpSocketException;
import ibm.nways.jdm.snmp.SnmpUnknownHostException;
import ibm.nways.jdm.snmp.SnmpV1API;
import ibm.nways.ras.RAS;
import ibm.nways.rping.RpingModel;
import ibm.nways.rping.RpingParms;
import java.rmi.RemoteException;

public class RpingModelImpl
extends RemoteModelImpl
implements RpingModel,
HandcodedModel {
    LocalModel localModel;
    SnmpSession newSession;
    private static final int RASID = 4;
    private static final int RASSUB = 1021;

    public void initLocalModel(LocalModel localModel) {
        this.localModel = localModel;
    }

    public Integer getRpingInfo(RpingParms rpingParms) throws RemoteException {
        Integer n;
        block7: {
            n = new Integer(-6);
            try {
                SnmpV1API.initialize();
                this.newSession = SnmpSession.open((String)rpingParms.ipSender, (String)rpingParms.community, (String)rpingParms.community, (int)0, (int)(rpingParms.timeOut + rpingParms.curTO), (int)rpingParms.remPort);
            }
            catch (SnmpUnknownHostException snmpUnknownHostException) {
                if (RAS.isEnabled(4, 1021)) {
                    RAS.trace(4, 1021, this, "getRpingInfo", "  problem with SNMP session : SnmpUnknownHostException");
                }
            }
            catch (SnmpSocketException snmpSocketException) {
                if (RAS.isEnabled(4, 1021)) {
                    RAS.trace(4, 1021, this, "getRpingInfo", "  problem with SNMP session : SnmpSocketException");
                }
            }
            catch (Exception exception) {
                if (!RAS.isEnabled(4, 1021)) break block7;
                RAS.trace(4, 1021, this, "getRpingInfo", "  problem with SNMP session : Exception");
            }
        }
        SnmpPDU snmpPDU = this.newSession.makePDU();
        snmpPDU.operation = 0;
        String string = "1.3.6.1.4.1.2.6.4.3.1.";
        string = string.concat(rpingParms.pktSize.toString());
        string = string.concat(".");
        string = string.concat(rpingParms.timeOut.toString());
        string = string.concat(".");
        string = string.concat(rpingParms.ipAddr.toString());
        snmpPDU.addVarBind(string);
        SnmpPDU snmpPDU2 = this.newSession.send(snmpPDU);
        if (snmpPDU2.errorStatus == 0) {
            n = (Integer)snmpPDU2.varBindAt(0).getVar();
        }
        this.newSession.close();
        return n;
    }
}

